VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "ADVANTEST U3800 WLAN Power Measurement (FFT Mode) : LAN V1.0"
   ClientHeight    =   7575
   ClientLeft      =   1200
   ClientTop       =   1935
   ClientWidth     =   12285
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7575
   ScaleWidth      =   12285
   Begin VB.Frame Frame4 
      Caption         =   "Using CH"
      Height          =   735
      Left            =   240
      TabIndex        =   70
      Top             =   6120
      Width           =   1815
      Begin VB.OptionButton SetCH2mode 
         Caption         =   "CH2"
         Height          =   375
         Left            =   1080
         TabIndex        =   72
         Top             =   240
         Width           =   615
      End
      Begin VB.OptionButton SetCH1mode 
         Caption         =   "CH1"
         Height          =   375
         Left            =   240
         TabIndex        =   71
         Top             =   240
         Value           =   -1  'True
         Width           =   615
      End
   End
   Begin VB.TextBox CHPavgcnt 
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   6480
      TabIndex        =   69
      Text            =   "10"
      Top             =   1680
      Width           =   375
   End
   Begin VB.TextBox CNTavgcnt 
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   6480
      TabIndex        =   68
      Text            =   "10"
      Top             =   3360
      Width           =   375
   End
   Begin VB.CheckBox AVGavg 
      Caption         =   "AVG-m"
      Height          =   255
      Left            =   6120
      TabIndex        =   67
      Top             =   4920
      Width           =   855
   End
   Begin VB.CheckBox FREQavg 
      Caption         =   "AVG-m"
      Height          =   255
      Left            =   6120
      TabIndex        =   66
      Top             =   3120
      Width           =   855
   End
   Begin VB.CheckBox CHPavg 
      Caption         =   "AVG-n"
      Height          =   255
      Left            =   6120
      TabIndex        =   65
      Top             =   1440
      Width           =   855
   End
   Begin VB.TextBox Text17 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   10680
      TabIndex        =   60
      Text            =   "200"
      Top             =   5760
      Width           =   735
   End
   Begin VB.TextBox Text16 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   10680
      TabIndex        =   59
      Text            =   "200"
      Top             =   5400
      Width           =   735
   End
   Begin VB.CheckBox AcpOnOff 
      Caption         =   "ACP On/Off @Span 1MHz"
      Height          =   375
      Left            =   9600
      TabIndex        =   58
      Top             =   6120
      Width           =   2415
   End
   Begin VB.TextBox Text11 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      ForeColor       =   &H000000FF&
      Height          =   285
      Left            =   7080
      TabIndex        =   53
      Top             =   6000
      Width           =   1455
   End
   Begin VB.TextBox Text10 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      ForeColor       =   &H000000FF&
      Height          =   285
      Left            =   7080
      TabIndex        =   52
      Top             =   5520
      Width           =   1455
   End
   Begin VB.Frame Frame3 
      Caption         =   "Detector Mode"
      Height          =   1095
      Left            =   10080
      TabIndex        =   49
      Top             =   2760
      Width           =   1815
      Begin VB.OptionButton Option6 
         Caption         =   "Avg (RMS)"
         Height          =   375
         Left            =   240
         TabIndex        =   51
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton Option5 
         Caption         =   "Sample"
         Height          =   375
         Left            =   240
         TabIndex        =   50
         Top             =   240
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin VB.CheckBox InstPreset 
      Caption         =   "Preset the SPA"
      Height          =   375
      Left            =   480
      TabIndex        =   47
      Top             =   6960
      Width           =   1455
   End
   Begin VB.TextBox Text15 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   2880
      TabIndex        =   45
      Top             =   5400
      Width           =   1215
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      ForeColor       =   &H0000FFFF&
      Height          =   4095
      Left            =   240
      ScaleHeight     =   801
      ScaleMode       =   0  'User
      ScaleWidth      =   1001
      TabIndex        =   43
      Top             =   1200
      Width           =   5175
   End
   Begin VB.TextBox Text14 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   10680
      TabIndex        =   21
      Text            =   "1"
      Top             =   4680
      Width           =   735
   End
   Begin VB.Frame Frame1 
      Height          =   615
      Left            =   2520
      TabIndex        =   18
      Top             =   6840
      Width           =   2895
      Begin VB.OptionButton Option2 
         Caption         =   "IF"
         Height          =   375
         Left            =   2160
         TabIndex        =   20
         Top             =   120
         Width           =   495
      End
      Begin VB.OptionButton Option1 
         Caption         =   "Free"
         Height          =   375
         Left            =   1320
         TabIndex        =   19
         Top             =   120
         Value           =   -1  'True
         Width           =   615
      End
      Begin VB.Label Label35 
         Caption         =   "Trigger Mode:"
         Height          =   255
         Left            =   120
         TabIndex        =   73
         Top             =   200
         Width           =   1095
      End
   End
   Begin VB.CheckBox ContMeas 
      Caption         =   "Continuous Measurement"
      Height          =   255
      Left            =   6120
      TabIndex        =   17
      Top             =   6960
      Width           =   2175
   End
   Begin VB.TextBox Text13 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   3600
      TabIndex        =   16
      Text            =   "0"
      Top             =   6480
      Width           =   1215
   End
   Begin VB.TextBox Text12 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   3600
      TabIndex        =   15
      Text            =   "2412"
      Top             =   6120
      Width           =   1215
   End
   Begin VB.TextBox Text9 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00E0E0E0&
      Height          =   285
      Left            =   10680
      TabIndex        =   14
      Top             =   2160
      Width           =   735
   End
   Begin VB.TextBox Text8 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00E0E0E0&
      Height          =   285
      Left            =   10680
      TabIndex        =   13
      Top             =   1800
      Width           =   735
   End
   Begin VB.TextBox Text7 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   10680
      TabIndex        =   12
      Text            =   "22"
      Top             =   1200
      Width           =   735
   End
   Begin VB.TextBox Text6 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   15.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   7080
      TabIndex        =   11
      Top             =   4560
      Width           =   1455
   End
   Begin VB.TextBox Text5 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   15.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   7080
      TabIndex        =   10
      Top             =   3600
      Width           =   1935
   End
   Begin VB.TextBox Text4 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   15.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   7080
      TabIndex        =   9
      Top             =   2880
      Width           =   1455
   End
   Begin VB.TextBox Text3 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   15.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   7080
      TabIndex        =   8
      Top             =   1920
      Width           =   1455
   End
   Begin VB.TextBox Text2 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0FFFF&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   15.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   7080
      TabIndex        =   7
      Top             =   1200
      Width           =   1455
   End
   Begin VB.CommandButton CommandStop 
      BackColor       =   &H00C0C0FF&
      Caption         =   "Stop"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   10320
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   6840
      Width           =   1455
   End
   Begin VB.CommandButton CommandMeas 
      BackColor       =   &H0080FF80&
      Caption         =   "Measure"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   8520
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   6840
      Width           =   1455
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   5760
      Top             =   240
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00FFFFC0&
      Height          =   285
      Left            =   7440
      TabIndex        =   5
      Text            =   "192.168.0.1"
      Top             =   360
      Width           =   1455
   End
   Begin VB.CommandButton Connect 
      BackColor       =   &H0080FF80&
      Caption         =   "Connect"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   9000
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   240
      Width           =   1455
   End
   Begin VB.CommandButton Gotolocal 
      BackColor       =   &H0000FFFF&
      Caption         =   "Local"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   10560
      Style           =   1  'Graphical
      TabIndex        =   3
      Top             =   240
      Width           =   1455
   End
   Begin VB.Line Line10 
      BorderStyle     =   3  'Dot
      X1              =   5880
      X2              =   12000
      Y1              =   5280
      Y2              =   5280
   End
   Begin VB.Line Line9 
      BorderStyle     =   3  'Dot
      X1              =   5880
      X2              =   12000
      Y1              =   4320
      Y2              =   4320
   End
   Begin VB.Line Line8 
      BorderStyle     =   3  'Dot
      X1              =   5880
      X2              =   9600
      Y1              =   2640
      Y2              =   2640
   End
   Begin VB.Line Line7 
      X1              =   120
      X2              =   5640
      Y1              =   5880
      Y2              =   5880
   End
   Begin VB.Label Label34 
      Caption         =   "kHz"
      Height          =   255
      Left            =   11520
      TabIndex        =   64
      Top             =   5760
      Width           =   375
   End
   Begin VB.Label Label33 
      Caption         =   "kHz"
      Height          =   255
      Left            =   11520
      TabIndex        =   63
      Top             =   5400
      Width           =   375
   End
   Begin VB.Label Label32 
      Caption         =   "Channel BW:"
      Height          =   255
      Left            =   9600
      TabIndex        =   62
      Top             =   5760
      Width           =   975
   End
   Begin VB.Label Label31 
      Caption         =   "Channel SP:"
      Height          =   255
      Left            =   9600
      TabIndex        =   61
      Top             =   5400
      Width           =   975
   End
   Begin VB.Label Label30 
      Caption         =   "dB"
      Height          =   255
      Left            =   8640
      TabIndex        =   57
      Top             =   6000
      Width           =   375
   End
   Begin VB.Label Label29 
      Caption         =   "dB"
      Height          =   255
      Left            =   8640
      TabIndex        =   56
      Top             =   5520
      Width           =   375
   End
   Begin VB.Label Label28 
      Caption         =   "ACP  Lower:"
      Height          =   255
      Left            =   5880
      TabIndex        =   55
      Top             =   6000
      Width           =   975
   End
   Begin VB.Label Label26 
      Caption         =   "ACP  Upper:"
      Height          =   255
      Left            =   5880
      TabIndex        =   54
      Top             =   5520
      Width           =   975
   End
   Begin VB.Line Line6 
      BorderStyle     =   3  'Dot
      X1              =   9600
      X2              =   9600
      Y1              =   1080
      Y2              =   4320
   End
   Begin VB.Label Label27 
      Caption         =   "ms"
      Height          =   255
      Left            =   11520
      TabIndex        =   48
      Top             =   4680
      Width           =   375
   End
   Begin VB.Label Label25 
      Caption         =   "sec"
      Height          =   255
      Left            =   4320
      TabIndex        =   46
      Top             =   5400
      Width           =   375
   End
   Begin VB.Label Label24 
      Caption         =   "Total  Measurement Time:"
      Height          =   255
      Left            =   840
      TabIndex        =   44
      Top             =   5400
      Width           =   1935
   End
   Begin VB.Label Label23 
      Caption         =   "dBm"
      Height          =   255
      Left            =   4920
      TabIndex        =   42
      Top             =   6480
      Width           =   495
   End
   Begin VB.Label Label22 
      Caption         =   "MHz"
      Height          =   255
      Left            =   4920
      TabIndex        =   41
      Top             =   6120
      Width           =   495
   End
   Begin VB.Label Label21 
      Caption         =   "Ref.Level:"
      Height          =   255
      Left            =   2640
      TabIndex        =   40
      Top             =   6480
      Width           =   975
   End
   Begin VB.Label Label20 
      Caption         =   "Center Freq.:"
      Height          =   255
      Left            =   2640
      TabIndex        =   39
      Top             =   6120
      Width           =   975
   End
   Begin VB.Label Label19 
      Caption         =   "ms"
      Height          =   255
      Left            =   11520
      TabIndex        =   38
      Top             =   2160
      Width           =   375
   End
   Begin VB.Label Label18 
      Caption         =   "MHz"
      Height          =   255
      Left            =   11520
      TabIndex        =   37
      Top             =   1800
      Width           =   495
   End
   Begin VB.Label Label17 
      Caption         =   "MHz"
      Height          =   255
      Left            =   11520
      TabIndex        =   36
      Top             =   1200
      Width           =   495
   End
   Begin VB.Label Label16 
      Caption         =   "dBm/MHz"
      Height          =   255
      Left            =   8640
      TabIndex        =   35
      Top             =   4680
      Width           =   855
   End
   Begin VB.Label Label15 
      Caption         =   "MHz"
      Height          =   255
      Left            =   9120
      TabIndex        =   34
      Top             =   3720
      Width           =   495
   End
   Begin VB.Label Label14 
      Caption         =   "kHz"
      Height          =   255
      Left            =   8640
      TabIndex        =   33
      Top             =   3000
      Width           =   495
   End
   Begin VB.Label Label13 
      Caption         =   "MHz"
      Height          =   255
      Left            =   8640
      TabIndex        =   32
      Top             =   2040
      Width           =   495
   End
   Begin VB.Label Label12 
      Caption         =   "dBm"
      Height          =   255
      Left            =   8640
      TabIndex        =   31
      Top             =   1320
      Width           =   495
   End
   Begin VB.Label Label11 
      Caption         =   "AVG Time:"
      Height          =   255
      Left            =   9840
      TabIndex        =   30
      Top             =   4680
      Width           =   855
   End
   Begin VB.Label Label10 
      Caption         =   "CT:"
      Height          =   255
      Left            =   10320
      TabIndex        =   29
      Top             =   2160
      Width           =   375
   End
   Begin VB.Label Label9 
      Caption         =   "CB:"
      Height          =   255
      Left            =   10320
      TabIndex        =   28
      Top             =   1800
      Width           =   375
   End
   Begin VB.Label Label8 
      Caption         =   "CHP BW:"
      Height          =   255
      Left            =   9840
      TabIndex        =   27
      Top             =   1200
      Width           =   855
   End
   Begin VB.Label Label7 
      Caption         =   "AVG Power:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   26
      Top             =   4560
      Width           =   1095
   End
   Begin VB.Label Label6 
      Caption         =   "Frequency:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   25
      Top             =   3840
      Width           =   1095
   End
   Begin VB.Label Label5 
      Caption         =   "SBW:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   24
      Top             =   2760
      Width           =   615
   End
   Begin VB.Label Label4 
      Caption         =   "OBW 99%:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   23
      Top             =   2160
      Width           =   975
   End
   Begin VB.Label Label3 
      Caption         =   "CH Power:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   22
      Top             =   1080
      Width           =   975
   End
   Begin VB.Line Line3 
      X1              =   5640
      X2              =   5640
      Y1              =   1080
      Y2              =   7440
   End
   Begin VB.Line Line2 
      X1              =   2280
      X2              =   2280
      Y1              =   5880
      Y2              =   7440
   End
   Begin VB.Line Line1 
      X1              =   5640
      X2              =   12120
      Y1              =   6600
      Y2              =   6600
   End
   Begin VB.Label Label1 
      Caption         =   "Power Measurement (FFT Mode)"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   18
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   495
      Left            =   240
      TabIndex        =   6
      Top             =   240
      Width           =   5415
   End
   Begin VB.Label Label2 
      Caption         =   "IP  ADDRESS:"
      Height          =   255
      Left            =   6240
      TabIndex        =   4
      Top             =   360
      Width           =   1215
   End
   Begin VB.Line Line4 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      X1              =   120
      X2              =   12120
      Y1              =   960
      Y2              =   960
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'*----------------------------------------------------------------------
'*.Program Name :        Power Measurement using FFT Function (TDA)
'*
'*      Sample software for Advantest Spectrum Analyzer U3800
'*       (WLAN Measurement Sample Software)
'*
'*.Description :
'*
'*.Revision History :
'*      Program name:                   U3800 PowerMeasFunc V1.0
'*
'*      Reference Program:              U3700(U3800) PowerMeasDGT
'*
'*      Ver1.0:                         JUN-15-2012     Release. by Hirakoso
'*
'*
'*------------------------ Display Error List --------------------------
'*
'*  Error-1     ; LAN Connection Fail?
'*  Error-2     ; Remote Now?
'*  Erreo-3     ; Run Measurement Now or Local? @Measure-Key
'*  Error-4     ; Run Measurement Now or Local? @Local-key
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2012 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------

Dim MFREQ As Double                     'Center Frequency for SPA set data
Dim REFL As Double                      'Reference Level for SPA set data
Dim RefLcal As Double                   'Reference Level for Calculation
Dim CHPBW As Double                     'CH Power BW
Dim AvgTime As Double                   'AVG Integer Time
Dim SBWSpan As Double                   'SBW Measurement Span
Dim SBWSwp As Double                    'SBW Time Data
Dim ChSpace As Double                   'ACP Channel Space
Dim InteBW As Double                    'ACP Integral BW
Dim AvgPowerPts As Integer              'AVG Power Calcu Points
Dim StartTime As Double                 'Measurement Start Time
Dim MeasExeFlag As Integer              'Measuring Flag
Dim RemoteMode As Integer               'Remote Mode
Dim MeasStopFlag As Integer             'Measurment stop flag
Dim AvgCntCNT As Integer                'Average Count CNT; Add V3.0
Dim AvgCntCHP As Integer                'Average Count CHP; Add V3.0
Dim ChannelMode As Integer              'Using CH1 or CH2; add U3800 V1.0

'
'=======================================================================
'                ************* MAIN ROUTINE **************
'=======================================================================

Private Sub CommandMeas_Click()

MFREQ = Val(Text12)                     'CF data for SPA; Sub_Connect & Here
REFL = Val(Text13)                      'REF.L data for SPA; Sub_Connect & Here
RefLcal = 0                             'REF.L data for Calculation (DGT=0)
CHPBW = Val(Text7)                      'Channel Power BW
AvgTime = Val(Text14)                   'AVG Power Time division
ChSpace = Val(Text16)                   'ACP Channel Space Data
InteBW = Val(Text17)                    'ACP IBW Data
MeasStopFlag = ContMeas.Value           'Measurement stop flag
AvgCntCNT = Val(CNTavgcnt)              'Average Count Number
AvgCntCHP = Val(CHPavgcnt)              'Average Count CHP Number
'---------------------------------------
If ChSpace < 10 Then ChSpace = 10       'ACP Data Check
If ChSpace > 500 Then ChSpace = 500
If InteBW < 10 Then InteBW = 10
If InteBW > 500 Then InteBW = 500
Text16.Text = ChSpace
Text17.Text = InteBW
'--------------------------------------'AVG Counter Check
If AvgCntCNT > 30 Then AvgCntCNT = 30
If AvgCntCNT < 2 Then AvgCntCNT = 2
If AvgCntCHP > 30 Then AvgCntCHP = 30
If AvgCntCHP < 2 Then AvgCntCHP = 2
CNTavgcnt.Text = AvgCntCNT
CHPavgcnt.Text = AvgCntCHP
'---------------------------------------'End of AVG Check


    If MeasExeFlag = 0 And RemoteMode = 1 Then
    
        Text15.Text = "Measure....."
    
        MeasExeFlag = 1
        
        Connect.Enabled = False
        Gotolocal.Enabled = False
        CommandMeas.Enabled = False
        If MeasStopFlag = 1 Then
            CommandStop.Enabled = True
        End If
    
        MeasAll                         '@@@@@ Measurement Sub Routine
        
        MeasExeFlag = 0
        
        Gotolocal.Enabled = True
        CommandMeas.Enabled = True
        CommandStop.Enabled = False
        
    Else
        Beep
        Text15.Text = "Error-4"
        
    End If


End Sub

'
'-----------------------------------------------------------------------
'                       Measurement
'-----------------------------------------------------------------------
Private Sub MeasAll()

Dim MeasCHPCB, MeasCHPCT As Double
Dim sBuff As String * 100
Dim OBWobw() As String
Dim CHpower, OBWfreq, SBWfreq, CentFreq, AVGpower As Double
Dim ACPacp() As String
Dim AcpUpper, AcpLower As Double


    SendDtFunc ("REN")                                  'Addition U3800 Ver1.0
                                                        'Move "Preset routine" to Connect
    
    '-----------------------Measurement CB/CT Calculation--------------------------------
    
    If CHPBW > 40 Then
        CHPBW = 40
        Text7.Text = Format(CHPBW, "#00")
    End If
    If CHPBW < 0.01 Then
        CHPBW = 0.01
        Text7.Text = Format(CHPBW, "#0.00")
    End If
    
    '------------------------CB, CT Data set ---------------
    Select Case CHPBW
    
        Case Is > 15
            MeasCHPCB = 40                              'MHz
            MeasCHPCT = 0.3                             'msec
        Case Is > 5
            MeasCHPCB = 30                              'MHz
            MeasCHPCT = 0.5                             'msec
        Case Is > 1.5
            MeasCHPCB = 10                              'MHz
            MeasCHPCT = 1                               'msec
        Case Is > 0.5
            MeasCHPCB = 3                               'MHz
            MeasCHPCT = 5                               'msec
        Case Else
            MeasCHPCB = 1                               'MHz
            MeasCHPCT = 10                              'msec
            
    End Select
    
    Text8.Text = Format(MeasCHPCB, "###0")
    Text9.Text = Format(MeasCHPCT, "#0.0")
    
    '-------------------------Setup----------------------------------------------
    
    SendDtFunc ("SI")                                   'Sweep STOP
    
    SendDtFunc ("TDANA ON")                             'Set Time Domain Mode
    SendDtFunc ("TMEAS FFT")                            'FFT Mode
    SendDtFunc ("TDAOFS 0 US")                          'FFT Offset = 0 us
    
    If Option5.Value = True Then                        'Detector Mode?
        SendDtFunc ("DET SMP")                              'Set DET Sample Mode
    Else
        SendDtFunc ("DET AVG")                              'Set DET AVG Mode
    End If

    If Option2.Value = True Then
        SendDtFunc ("TRGSRC IF")                        'Set Trigger Mode (IF)
    Else
        SendDtFunc ("TRGSRC FREE")                      'Free Run
    End If
    ' SendDtFunc ("RO ON; RO 0 DB")                     'Level Offset
    SendDtFunc ("RL " & Format(REFL) & "DB")            'Reference level
    
    '----------------------------------------------------
    SendDtFunc ("CSBSDEL")                              'ACP Table Clear & Set CS,BS Data
    SendDtFunc ("CSBSIN " & Format(ChSpace * 1000) & "," & Format(InteBW * 1000))
    SendDtFunc ("ACPSCR FULL")                          'ACP Carrier Mode = Full
    
    '
    DoEvents                                            'Check initerrupt routine
    '----------------------------------------------------
Do
'------------------------------------------------------------------------------------------
    
    StartTime = Timer '***************** Start Measurement **********************
    
    '============================================================================
    
'------------------------------------ Channel Power ---------------------------------------
    
    SendDtFunc ("CF " & Format(MFREQ) & "MZ")           'Center frequency (MHz)
    
    SendDtFunc ("TMEAS FFT")                            'FFT Mode
    SendDtFunc ("CAPBW " & Format(MeasCHPCB) & "MZ")    'Capture BW
    SendDtFunc ("CAPTIM " & Format(MeasCHPCT) & "MS")   'Capture Time
    
    SendDtFunc ("WLX " & Format(MFREQ) & "MZ")          'CHP Center
    SendDtFunc ("WDX " & Format(CHPBW) & "MZ")          'CHP IBW
    
    SendDtFunc ("PWCHON ON")                            'Channel Power Mode
    
    '---------------------------------------------------------------------------------
    If CHPavg.Value = 1 Then                            'AVG Mode On ?

        SendDtFunc ("PMEASAVGONCE ONCE")                'AVG Single
        SendDtFunc ("PWCHTM " & Format(AvgCntCHP))      'AVG n times
        SendDtFunc ("PMEASAVG ON")                      'AVG start
        SendDtFunc ("CONTS")                            'Sweep continue
        If ChannelMode = 1 Then
            WaitMeasEnd                                     'Wait AVG end CH1
        Else
            WaitMeasEnd_CH2                                 'Wait AVG end CH2
        End If                                              '
        SendDtFunc ("SI")                               'Sweep Stop
        SendDtFunc ("PMEASAVG OFF")                     ' AVG OFF

    Else
    
        SendDtFunc ("SI")                               'Sweep Once Auto
        If ChannelMode = 1 Then
            WaitSweepEnd                                    'Wait Sweep end CH1
        Else
            WaitSweepEnd_CH2                                'Wait Sweep end CH2
        End If                                              '
    
    End If
    
    '-------------------------Get CH Power ---------------------------------
    
    sBuff = ""
      
    SendDtFunc ("PWCH?")                                'Send CHP Command
    
    sBuff = RcvDtFunc                                   'Get Data
    CHpower = Val(sBuff)
    
    '------------------------- Data Display --------------------------------
    
    Text2.Text = Format(CHpower, "###0.00")
        
    '--------------------- Display Wide Band Waveform ----------------------

    SendDtFunc ("TBA?")                                 ' A TRace & Set BIN mode
    
    bGetWave                                            ' Get Trace Data
    
    SPA_line                                            ' Draw Line
    

'------------------------------------------ OBW ------------------------------------------
    
    
    SendDtFunc ("OBWPER 99")                                    'OBW 99%
    
    SendDtFunc ("OBWON ON")                                     'OBW ON
    
    '---------------------------------------------------------------------------------
    If CHPavg.Value = 1 Then                            'AVG Mode On ?

        SendDtFunc ("PMEASAVGONCE ONCE")                'AVG Single
        SendDtFunc ("OBWTM " & Format(AvgCntCHP))       'AVG n times
        SendDtFunc ("PMEASAVG ON")                      'AVG start
        SendDtFunc ("CONTS")                            'Sweep continue
        If ChannelMode = 1 Then
            WaitMeasEnd                                      'Wait AVG end CH1
        Else
            WaitMeasEnd_CH2                                  'Wait AVG end CH2
        End If
        SendDtFunc ("SI")                               'Sweep Stop
        SendDtFunc ("PMEASAVG OFF")                     ' AVG OFF

    Else
    
        SendDtFunc ("SI")                               'Sweep Once Auto
        If ChannelMode = 1 Then
            WaitSweepEnd                                    'Wait Sweep end CH1
        Else
            WaitSweepEnd_CH2                                'Wait Sweep end CH2
        End If                                              '
    
    End If
    
    '-------------------------Get OBW ---------------------------------
    
    sBuff = ""
      
    SendDtFunc ("OBW?")                                 'Send OBW Command
    
    sBuff = RcvDtFunc                                   'Get Data
    OBWobw = Split(sBuff, ",")
    
    OBWfreq = Val(OBWobw(1)) / 1000000                  'Hz to MHz
    
    '------------------------- Data Display ----------------------------
    
    If OBWfreq > 10 Then
        Text3.Text = Format(OBWfreq, "##0.0")                   'MHz
    Else
        If OBWfreq > 1 Then
            Text3.Text = Format(OBWfreq, "##0.00")              'MHz
        Else
            Text3.Text = Format(OBWfreq, "#0.000")              'MHz
        End If
    End If
    
    '-------------------------------------------------------------------------------


'----------------------------------------- SBW -------------------------------------------
    
    
    '--------------------------SBW Setup----(Fixed Data)--------------------------------
    
    SendDtFunc ("OBWPER 90")                            'SBW (= OBW 90%)
    
    SBWSpan = 1                                         'SBW Mwasurement Span (MHz)
    SBWSwp = 5                                          'SBW Sweep Time (ms)
    
    SendDtFunc ("CAPTIM " & Format(SBWSwp) & "MS")      'Capture Time
    SendDtFunc ("CAPBW " & Format(SBWSpan) & "MZ")      'Capture BW
    
                                                        'Average mode
    If FREQavg.Value = 1 Then                           'AVG Mode?
        
        SendDtFunc ("PMEASAVGONCE ONCE")                'AVG Single
        SendDtFunc ("OBWTM " & Format(AvgCntCNT))       'AVG n times
        SendDtFunc ("PMEASAVG ON")                      'AVG start
        SendDtFunc ("CONTS")                            'Sweep continue
        If ChannelMode = 1 Then
            WaitMeasEnd                                      'Wait AVG end CH1
        Else
            WaitMeasEnd_CH2                                  'Wait AVG end CH2
        End If
        SendDtFunc ("SI")                               'Sweep Stop
        SendDtFunc ("PMEASAVG OFF")                     ' AVG OFF
        
    Else
    
        SendDtFunc ("SI")                                   'Sweep Once Auto
        If ChannelMode = 1 Then
            WaitSweepEnd                                    'Wait Sweep end CH1
        Else
            WaitSweepEnd_CH2                                'Wait Sweep end CH1
        End If
    
    End If
    
    '------------------------------ Get SBW ---------------------------------
    
    sBuff = ""
      
    SendDtFunc ("OBW?")                                 'Send OBW Command
    
    sBuff = RcvDtFunc                                   'Get Data
    OBWobw = Split(sBuff, ",")
    
    OBWfreq = Val(OBWobw(1)) / 1000                     'Hz to kHz
    CentFreq = Val(OBWobw(0)) / 1000000                 'Hz to MHz
    
    '-------------------------- Data Display --------------------------------
       
    Text4.Text = Format(OBWfreq, "###0.0")              'kHz (Normal measurement)
        
    Text5.Text = Format(CentFreq, "###0.0000")          'Frequency Display (MHz)
    
    '-------------------------- SBW Trace------------------------------------

'    SendDtFunc ("TBA?")                                 ' A TRace & Set BIN mode
'
'    bGetWave                                            ' Get Trace Data
'
'    SPA_line                                            ' Draw Line
    
   '-------------------------------------------------------------------------
    
'----------------------------------------- ACP -------------------------------------------
    
    If AcpOnOff.Value = 1 Then
    
    
        SendDtFunc ("ACPON")                                'ACP ON
        
        SendDtFunc ("SI")                                   'Sweep Once Auto
        If ChannelMode = 1 Then
            WaitSweepEnd                                    'Wait Sweep end CH1
        Else
            WaitSweepEnd_CH2                                'Wait Sweep end CH1
        End If
        
        '------------------------- Get ACP Power ---------------------------------
         
        sBuff = ""
           
        Sleep 10                                            'Wait 10ms for ready
        SendDtFunc ("ACP?")                                 'Send ACP Command
        
        Sleep 10                                            'Wait 10ms for ready
        sBuff = RcvDtFunc                                   'Get Count Data >> Skip
        sBuff = ""
        sBuff = RcvDtFunc                                   'Get ACP FL,LL,FH,LH Data
        ACPacp = Split(sBuff, ",")
        
        AcpUpper = Val(ACPacp(3))                           'String to Real
        AcpLower = Val(ACPacp(1))                           'Data(n) = FL,LL,FH,LH
    
        Text10.Text = Format(AcpUpper, "###0.00")
        Text11.Text = Format(AcpLower, "###0.00")

    Else
    
        Text10.Text = ""
        Text11.Text = ""
        
    End If
    
    '----------------------------------------------------------------------------

    SendDtFunc ("PMEASOFF")                             'Power Measurement OFF
    
    
'----------------------------------------- AVG Power --------------------------------------

    SendDtFunc ("TMEAS PWR")                            'Change trace to Power vs Time
    
    SendDtFunc ("PWAVGRANGE WIN")                       'Window Measurement
    SendDtFunc ("WDX " & Format(AvgTime) & "MS")                      'Power Avg Time
    SendDtFunc ("WLX " & Format(SBWSwp * 0.05 + AvgTime / 2) & "MS")  'WD Center (50 points shift)
    
    SendDtFunc ("PWAVGON ON")                           'AVG Power ON
    
    If AVGavg.Value = 1 Then                            'AVG Mode ?
        
        SendDtFunc ("PMEASAVGONCE ONCE")                'AVG Single
        SendDtFunc ("PWAVGTM " & Format(AvgCntCNT))     'AVG n times
        SendDtFunc ("PMEASAVG ON")                      'AVG start
        SendDtFunc ("CONTS")                            'Sweep continue
        If ChannelMode = 1 Then
            WaitMeasEnd                                      'Wait AVG end CH1
        Else
            WaitMeasEnd_CH2                                  'Wait AVG end CH2
        End If
        SendDtFunc ("SI")                               'Sweep Stop
        SendDtFunc ("PMEASAVG OFF")                     ' AVG OFF
        
    Else
    
        SendDtFunc ("SI")                                   'Sweep Once Auto
        If ChannelMode = 1 Then
            WaitSweepEnd                                    'Wait Sweep end CH1
        Else
            WaitSweepEnd_CH2                                'Wait Sweep end CH1
        End If
        
    End If
                                
   '------------------------- Get AVG Power ---------------------------------
    
    sBuff = ""
      
    SendDtFunc ("PWAVG?")                                'Send AVG Command
    
    sBuff = RcvDtFunc                                    'Get Data
    AVGpower = Val(sBuff)
 
    Text6.Text = Format(AVGpower, "###0.00")
    
    '-------------------------- AVG Power Trace------------------------------

    SendDtFunc ("TBA?")                                 ' A TRace & Set BIN mode
    
    bGetWave                                            ' Get Trace Data
        
    SPA_line                                            ' Draw Line
    
   '-------------------------------------------------------------------------
    
    SendDtFunc ("PWAVGON OFF")                           'Power Measurement OFF
        
'---------------------------------------------------------------------------------------

    
    '===================================================================================
    
    Text15.Text = Format((Timer - StartTime), "###0.00") '***** Measurement Time *****
    
    DoEvents                                            'Check interrupt routine
    
Loop While MeasStopFlag = 1

'------------------------------ Set End Condition --------------------------------------

    SendDtFunc ("TMEAS FFT")                               'FFT Mode
    SendDtFunc ("DETAA ON")                                'DET Auto
    SendDtFunc ("TRGSRC FREE")                             'Set Trigger Mode
    SendDtFunc ("CONTS")                                   'Sweep Start,,,


End Sub

'
'-----------------------------------------------------------------------
'               Stop Measurement
'-----------------------------------------------------------------------

Private Sub CommandStop_Click()

    MeasStopFlag = 0                                    'Measurement stop flag
    
    ContMeas.Value = 0                                  'Check Box Off
    
    Connect.Enabled = False
    Gotolocal.Enabled = True
    CommandMeas.Enabled = True
    CommandStop.Enabled = False
    
    Text15.Text = ">>> Stop....."
    
    Beep

End Sub

'
'-----------------------------------------------------------------------
'               CHP Averaging Data Check if Key Data-in
'-----------------------------------------------------------------------
Private Sub CHPavgcnt_KeyPress(KeyAscii As Integer)

    If KeyAscii = 13 Then
    
        AvgCntCHP = Val(CHPavgcnt)              'Average Count CHP Number
        If AvgCntCHP > 30 Then AvgCntCHP = 30
        If AvgCntCHP < 1 Then AvgCntCHP = 2
        CHPavgcnt.Text = AvgCntCHP
    
    End If

End Sub

'
'-----------------------------------------------------------------------
'              SBW,Freq... Averaging Data Check if Key Data-in
'-----------------------------------------------------------------------
Private Sub CNTavgcnt_KeyPress(KeyAscii As Integer)


    If KeyAscii = 13 Then
    
        AvgCntCNT = Val(CNTavgcnt)              'Average Count SBW Number
        If AvgCntCNT > 30 Then AvgCntCNT = 30
        If AvgCntCNT < 1 Then AvgCntCNT = 2
        CNTavgcnt.Text = AvgCntCNT
        
    End If

End Sub

'
'
'===============================================================================
'                           Control Routine
'===============================================================================
'
'
'------------------------------------------------------------
'                   LAN Connect
'------------------------------------------------------------
Private Sub Connect_Click()

Dim ErrRet As Integer

MFREQ = Val(Text12)                                         'CF data for SPA initialize
REFL = Val(Text13)                                          'REF.L data for SPA initialize

    If SetCH1mode.Value = True Then     '-------------------'Addition; U3800 Ver1.0
        ChannelMode = 1                                     'Using CH1
    Else
        ChannelMode = 0
    End If                              '-------------------'Using CH1 or CH2 mode
 
    IP_ADRS = Text1.Text                                    'IP Address Setting

    If RemoteMode = 0 Then
    
        LAN_Connect (ErrRet)
        
        If ErrRet = 0 Then
        
            Text15.Text = "Initialize SPA....."
            SendDtFunc ("PARSER ATSET")                     'SET Command Mode AT
            Sleep 100                                       'Wait Remote Setting Time
            
            '-----------------------------------------------'Addition U3800 Ver1.0
            If InstPreset.Value = 1 Then                        'Preset ON?
                SendDtFunc ("IP")                               'Instrument Reset
                DoEvents
                InstPreset.Value = 0                            'Clear Flag
                Sleep 3500                                      'Wait Preset
            End If
            
            SendDtFunc ("SYSMODE ASYNC")                        'SynMode Off
            
            If ChannelMode = 1 Then
                SendDtFunc ("ACTCH CH1")                        'ACTCH CH1
            Else
                SendDtFunc ("ACTCH CH2")                        'ACTCH CH2
            End If
            
            ' SendDtFunc ("RFC RFC1")                           'Set Input_Low(1) for U3872
                                                                'U3872's initial Input is High
            SendDtFunc ("IMGSP OFF")                            'Set IS_OFF (When the mode is ON)
            
            SendDtFunc ("SP 52MZ")                              'Span Initial Set (26*2)
            SendDtFunc ("CF " & Format(MFREQ) & "MZ")           'Center frequency (MHz)
            ' SendDtFunc ("RB 1MZ; VB 1MZ")                       'RBW, VBW
            ' SendDtFunc ("RO ON; RO 0 DB")                       'Level Offset
            SendDtFunc ("RL " & Format(REFL) & "DB")            'Reference level
            
            SendDtFunc ("TDANA ON")                             'Set Time Domain Mode
            SendDtFunc ("TMEAS FFT")                            'Display FFT
            
            DoEvents
            
            Sleep 500                                           'Wait Remote Setting Time
            '-----------------------------------------------'End of Addtion
            
            RemoteMode = 1                                  'Ready Remote
            
            Connect.Enabled = False                         'Key Off
            Gotolocal.Enabled = True                        'Key On
            CommandMeas.Enabled = True
            CommandStop.Enabled = False
            
            SetCH1mode.Enabled = False
            SetCH2mode.Enabled = False
            InstPreset.Enabled = False
            
            Text15.Text = "Ready....."
            
        Else
            Beep
            Text15.Text = "Error-1"

        End If
        
    Else
       Beep
       Text15.Text = "Error-2"
       
    End If


End Sub

'
'----------------------------------------------------------------
'                GOTO Local and LAN Disconnect
'----------------------------------------------------------------
Private Sub Gotolocal_Click()

Dim ErrRet As Integer

    If MeasExeFlag = 0 And RemoteMode = 1 Then
    
    
        SendDtFunc ("GTL")                                      'GO TO Local
        
        LAN_Dicconnect (ErrRet)
    
        Sleep 100
        
        RemoteMode = 0                                          'LOCAL
        
        Connect.Enabled = True
        Gotolocal.Enabled = False
        CommandMeas.Enabled = False
        CommandStop.Enabled = False
                
        SetCH1mode.Enabled = True
        SetCH2mode.Enabled = True
        InstPreset.Enabled = True
        
        Text15.Text = "Local....."
        
        'Only Go TO LOCAL
    Else
        Beep
        Text15.Text = "Error-3"
        
    End If
    
End Sub

'
'---------------------------------------------------------------
'                   Form Load
'---------------------------------------------------------------
Private Sub Form_Load()
Dim i As Integer


    MeasExeFlag = 0                                            'Not ready measurement
    RemoteMode = 0
    
    Picture1.Cls                                               'Clear Picture

    For i = 1 To 9
        Picture1.Line (0, i * 80)-(1000, i * 80), RGB(0, 0, 200)
    Next i

    For i = 1 To 9
        Picture1.Line (i * 100, 0)-(i * 100, 800), RGB(0, 0, 200)
    Next i
    
    
    Connect.Enabled = True
    Gotolocal.Enabled = False
    CommandMeas.Enabled = False
    CommandStop.Enabled = False
    
    Text15.Text = "Local....."


End Sub

'
'--------------------------------------------------------------------------
'                       Write SPA Data on Picture
'--------------------------------------------------------------------------

Private Sub SPA_line()

Dim i As Integer

    AutoRedraw = False
    Picture1.Cls
    
    AutoRedraw = True
    
    
    For i = 1 To 9
        Picture1.Line (0, i * 80)-(1000, i * 80), RGB(0, 0, 200)
    Next i
    
    For i = 1 To 9
        Picture1.Line (i * 100, 0)-(i * 100, 800), RGB(0, 0, 200)
    Next i
    
    
    Picture1.PSet (0, (800 - ((TraceP(0) - 1792) / 16)))
    
    For i = 1 To 1000
         Picture1.Line -(i, (800 - ((TraceP(i) - 1792) / 16)))
    Next i
    
    AutoRedraw = False

End Sub


